/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import static gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatus.CORRELATED;
import static gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatus.CORRELATIONINVALID;
import static gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatus.FAILEDCORRELATION;
import static gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatus.FAILEDUNCORRELATION;
import static gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatus.MVIDATAMATCH;
import static gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatus.PENDINGCORRELATION;
import static gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatus.PENDINGUNCORRELATION;
import static gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatus.UNCORRELATED;

import gov.va.med.mhv.common.data.model.Patient;

/**
 * @author PII
 *
 */
public final class PatientCorrelationStatusUtils {
    
   
    public static boolean isUncorrelated(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return UNCORRELATED.equals(patient.getCorrelationStatus());
    }

    public static boolean isCorrelated(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return CORRELATED.equals(patient.getCorrelationStatus());
    }

    public static boolean isPendingCorrelation(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return PENDINGCORRELATION.equals(patient.getCorrelationStatus());
    }

    public static boolean isPendingUncorrelation(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return PENDINGUNCORRELATION.equals(patient.getCorrelationStatus());
    }

    public static boolean isFailedCorrelation(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return FAILEDCORRELATION.equals(patient.getCorrelationStatus());
    }

    public static boolean isFailedUncorrelation(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return FAILEDUNCORRELATION.equals(patient.getCorrelationStatus());
    }

    public static boolean isCorrelationInvalid(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return CORRELATIONINVALID.equals(patient.getCorrelationStatus());
    }

    public static boolean isMviDataMatch(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        return MVIDATAMATCH.equals(patient.getCorrelationStatus());
    }
    
    private PatientCorrelationStatusUtils() {
    }

}
